Attribute VB_Name = "RegFunc"
Option Explicit

' This code for manipulating the registry comes from the VB5 samples

Public Declare Function RegOpenKeyEx Lib "advapi32" Alias "RegOpenKeyExA" (ByVal hKey As Long, ByVal lpSubKey As String, ByVal ulOptions As Long, ByVal samDesired As Long, ByRef phkResult As Long) As Long
Public Declare Function RegQueryValueEx Lib "advapi32" Alias "RegQueryValueExA" (ByVal hKey As Long, ByVal lpValueName As String, ByVal lpReserved As Long, ByRef lpType As Long, ByVal lpData As String, ByRef lpcbData As Long) As Long
Public Declare Function RegCloseKey Lib "advapi32.dll" (ByVal hKey As Long) As Long


' Reg Key Security Options...
Public Const READ_CONTROL = &H20000
Public Const KEY_QUERY_VALUE = &H1
Public Const KEY_SET_VALUE = &H2
Public Const KEY_CREATE_SUB_KEY = &H4
Public Const KEY_ENUMERATE_SUB_KEYS = &H8
Public Const KEY_NOTIFY = &H10
Public Const KEY_CREATE_LINK = &H20
Public Const KEY_ALL_ACCESS = KEY_QUERY_VALUE + KEY_SET_VALUE + _
                       KEY_CREATE_SUB_KEY + KEY_ENUMERATE_SUB_KEYS + _
                       KEY_NOTIFY + KEY_CREATE_LINK + READ_CONTROL
                     
' Reg Key ROOT Types...
Public Const HKEY_CLASSES_ROOT = &H80000000
Public Const HKEY_CURRENT_USER = &H80000001
Public Const HKEY_LOCAL_MACHINE = &H80000002
Public Const HKEY_USERS = &H80000003
Public Const HKEY_CURRENT_CONFIG = &H80000005

Public Const ERROR_SUCCESS = 0
Public Const REG_SZ = 1                         ' Unicode nul terminated string
Public Const REG_DWORD = 4                      ' 32-bit number


Public Function GetKeyValue(KeyRoot As Long, KeyName As String, SubKeyRef As String, ByRef KeyVal As String) As Boolean
  Dim i As Long                                           ' Loop Counter
  Dim rc As Long                                          ' Return Code
  Dim hKey As Long                                        ' Handle To An Open Registry Key
  Dim hDepth As Long                                      '
  Dim KeyValType As Long                                  ' Data Type Of A Registry Key
  Dim tmpVal As String                                    ' Tempory Storage For A Registry Key Value
  Dim KeyValSize As Long                                  ' Size Of Registry Key Variable
  '------------------------------------------------------------
  ' Open RegKey Under KeyRoot {HKEY_LOCAL_MACHINE...}
  '------------------------------------------------------------
  rc = RegOpenKeyEx(KeyRoot, KeyName, 0, KEY_ALL_ACCESS, hKey) ' Open Registry Key
  
  If (rc <> ERROR_SUCCESS) Then GoTo GetKeyError          ' Handle Error...
  
  tmpVal = String$(1024, 0)                               ' Allocate Variable Space
  KeyValSize = 1024                                       ' Mark Variable Size
  
  '------------------------------------------------------------
  ' Retrieve Registry Key Value...
  '------------------------------------------------------------
  rc = RegQueryValueEx(hKey, SubKeyRef, 0, _
                       KeyValType, tmpVal, KeyValSize)    ' Get/Create Key Value
  
  If (rc <> ERROR_SUCCESS) Then GoTo GetKeyError          ' Handle Errors
  
  If (Asc(Mid(tmpVal, KeyValSize, 1)) = 0) Then           ' Win95 Adds Null Terminated String...
      tmpVal = Left(tmpVal, KeyValSize - 1)               ' Null Found, Extract From String
  Else                                                    ' WinNT Does NOT Null Terminate String...
      tmpVal = Left(tmpVal, KeyValSize)                   ' Null Not Found, Extract String Only
  End If
  '------------------------------------------------------------
  ' Determine Key Value Type For Conversion...
  '------------------------------------------------------------
  Select Case KeyValType                                  ' Search Data Types...
  Case REG_SZ                                             ' String Registry Key Data Type
      KeyVal = tmpVal                                     ' Copy String Value
  Case REG_DWORD                                          ' Double Word Registry Key Data Type
      For i = Len(tmpVal) To 1 Step -1                    ' Convert Each Bit
          KeyVal = KeyVal + Hex(Asc(Mid(tmpVal, i, 1)))   ' Build Value Char. By Char.
      Next
      KeyVal = Format$("&h" + KeyVal)                     ' Convert Double Word To String
  End Select
  
  GetKeyValue = True                                      ' Return Success
  rc = RegCloseKey(hKey)                                  ' Close Registry Key
  Exit Function                                           ' Exit
  
GetKeyError:    ' Cleanup After An Error Has Occured...
  KeyVal = ""                                             ' Set Return Val To Empty String
  GetKeyValue = False                                     ' Return Failure
  rc = RegCloseKey(hKey)                                  ' Close Registry Key
End Function

Function FileExists(FileName As String) As Integer
'A simple function to determine whether a file exists
Dim i As Integer
On Error Resume Next

    i = Len(Dir$(FileName))
    FileExists = Not Err And Not (i = 0)

End Function


